﻿using System;
using System.Collections.Generic;

namespace VIRP.EFR.UTIL
{
    public class KeyValueComparer : IComparer<KeyValuePair<int, string>>
    {
        public int Compare(KeyValuePair<int, string> left, KeyValuePair<int, string> right)
        {
            if (left.Value.ToLower() == right.Value.ToLower())
                return 0;

            if (left.Value.ToLower() == "other")
                return Int32.MaxValue;

            if (right.Value.ToLower() == "other")
                return Int32.MinValue;

            return Comparer<string>.Default.Compare(left.Value, right.Value);
        }
    }
}
